/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.fabric;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import owmii.powah.EnvHandler;
import owmii.powah.block.Tier;
import owmii.powah.block.cable.CableTile;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.fabric.block.FabricCableTile;
import owmii.powah.fabric.data.ITags;
import owmii.powah.fabric.transfer.EnergyItemWrapper;
import owmii.powah.fabric.transfer.EnergyParticipant;
import owmii.powah.fabric.transfer.InventoryWrapper;
import owmii.powah.fabric.transfer.TankWrapper;
import owmii.powah.item.ItemGroups;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IBlock;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.item.ItemBlock;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.Inventory;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;
import team.reborn.energy.api.base.DelegatingEnergyStorage;

public class FabricEnvHandler
implements EnvHandler {
    @Override
    public void setupBlockItems() {
        for (class_2248 block : class_7923.field_41175) {
            if (!(block instanceof IBlock)) continue;
            IBlock iBlock = (IBlock)block;
            ItemBlock blockItem = iBlock.getBlockItem(new class_1792.class_1793(), ItemGroups.MAIN_KEY);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_7923.field_41175.method_10221((Object)block), (Object)blockItem);
        }
    }

    @Override
    public void registerWorldgen() {
        EnvHandler.super.registerWorldgen();
    }

    @Override
    public void scheduleCommonSetup(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void handleReactorInitClient(Consumer<?> consumer) {
    }

    @Override
    public class_6862<class_1959> getOverworldBiomeTag() {
        return ConventionalBiomeTags.IN_OVERWORLD;
    }

    @Override
    public void registerTransfer() {
        EnergyStorage.SIDED.registerFallback((level, pos, state, be, side) -> {
            ReactorPartTile reactorPart;
            Optional<ReactorTile> core;
            if (be instanceof ReactorPartTile && (core = (reactorPart = (ReactorPartTile)be).core()).isPresent() && reactorPart.isExtractor()) {
                return (EnergyStorage)EnergyStorage.SIDED.find(level, core.get().method_11016(), null, (class_2586)core.get(), side);
            }
            return null;
        });
        FluidStorage.SIDED.registerFallback((level, pos, state, be, side) -> {
            ReactorPartTile reactorPart;
            Optional<ReactorTile> core;
            if (be instanceof ReactorPartTile && (core = (reactorPart = (ReactorPartTile)be).core()).isPresent()) {
                return (Storage)FluidStorage.SIDED.find(level, core.get().method_11016(), null, (class_2586)core.get(), side);
            }
            return null;
        });
        ItemStorage.SIDED.registerFallback((level, pos, state, be, side) -> {
            ReactorPartTile reactorPart;
            Optional<ReactorTile> core;
            if (be instanceof ReactorPartTile && (core = (reactorPart = (ReactorPartTile)be).core()).isPresent()) {
                return (Storage)ItemStorage.SIDED.find(level, core.get().method_11016(), null, (class_2586)core.get(), side);
            }
            return null;
        });
        EnergyStorage.SIDED.registerFallback((level, pos, state, be, side) -> {
            if (be instanceof AbstractEnergyStorage) {
                final AbstractEnergyStorage energyStorage = (AbstractEnergyStorage)be;
                if (be instanceof FabricCableTile) {
                    final FabricCableTile cableTile = (FabricCableTile)be;
                    if (cableTile.isEnergyPresent((class_2350)side)) {
                        return new DelegatingEnergyStorage(EnergyStorage.EMPTY, () -> false, (class_2350)side){
                            final /* synthetic */ class_2350 val$side;
                            {
                                this.val$side = class_23502;
                                super(backingStorage, validPredicate);
                            }

                            public long insert(long maxAmount, TransactionContext transaction) {
                                return cableTile.insert(maxAmount, transaction, this.val$side);
                            }
                        };
                    }
                } else if (energyStorage.isEnergyPresent((class_2350)side)) {
                    return new EnergyStorage(){
                        final /* synthetic */ class_2350 val$side;
                        {
                            this.val$side = class_23502;
                        }

                        public long insert(long maxAmount, TransactionContext transaction) {
                            StoragePreconditions.notNegative((long)maxAmount);
                            EnergyParticipant.get(energyStorage.getEnergy()).updateSnapshots(transaction);
                            return energyStorage.receiveEnergy(maxAmount, false, this.val$side);
                        }

                        public long extract(long maxAmount, TransactionContext transaction) {
                            StoragePreconditions.notNegative((long)maxAmount);
                            EnergyParticipant.get(energyStorage.getEnergy()).updateSnapshots(transaction);
                            return energyStorage.extractEnergy(maxAmount, false, this.val$side);
                        }

                        public long getAmount() {
                            return energyStorage.getEnergy().getEnergyStored();
                        }

                        public long getCapacity() {
                            return energyStorage.getEnergy().getCapacity();
                        }

                        public boolean supportsInsertion() {
                            return energyStorage.canReceiveEnergy(this.val$side);
                        }

                        public boolean supportsExtraction() {
                            return energyStorage.canExtractEnergy(this.val$side);
                        }
                    };
                }
            }
            return null;
        });
        ItemStorage.SIDED.registerFallback((level, pos, state, be, side) -> {
            IInventoryHolder holder;
            Inventory inv;
            if (be instanceof IInventoryHolder && !(inv = (holder = (IInventoryHolder)be).getInventory()).isBlank()) {
                return (InventoryWrapper)((Object)((Object)inv.getPlatformWrapper()));
            }
            return null;
        });
        FluidStorage.SIDED.registerFallback((level, pos, state, be, side) -> {
            if (be instanceof ITankHolder) {
                ITankHolder holder = (ITankHolder)be;
                Tank tank = holder.getTank();
                return (TankWrapper)((Object)((Object)tank.getPlatformWrapper()));
            }
            return null;
        });
        EnergyStorage.ITEM.registerFallback((stack, context) -> {
            IEnergyContainingItem eci;
            IEnergyContainingItem.Info info;
            class_1792 patt8450$temp = stack.method_7909();
            if (patt8450$temp instanceof IEnergyContainingItem && (info = (eci = (IEnergyContainingItem)patt8450$temp).getEnergyInfo()) != null) {
                return EnergyItemWrapper.create(context, info.capacity(), info.maxInsert(), info.maxExtract());
            }
            return null;
        });
    }

    public InventoryWrapper createInvWrapper(Inventory inventory) {
        return new InventoryWrapper(inventory);
    }

    @Override
    public boolean isWrench(class_1799 stack) {
        return stack.method_31573(ITags.Items.WRENCHES);
    }

    public TankWrapper createTankWrapper(Tank tank) {
        return new TankWrapper(tank);
    }

    @Override
    public boolean interactWithTank(class_1657 player, class_1268 hand, Tank tank) {
        Storage handStorage = Objects.requireNonNullElse((Storage)(player.method_31549().field_7477 ? ContainerItemContext.withConstant((class_1799)player.method_5998(hand)) : ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand)).find(FluidStorage.ITEM), Storage.empty());
        TankWrapper tankWrapper = this.createTankWrapper(tank);
        return StorageUtil.move((Storage)tankWrapper, (Storage)handStorage, fv -> true, (long)Long.MAX_VALUE, null) > 0L || StorageUtil.move((Storage)handStorage, (Storage)tankWrapper, fv -> true, (long)Long.MAX_VALUE, null) > 0L;
    }

    @Override
    public boolean canDischarge(class_1799 stack) {
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    @Override
    public boolean hasEnergy(class_1937 level, class_2338 pos, class_2350 side) {
        return EnergyStorage.SIDED.find(level, pos, (Object)side) != null;
    }

    @Override
    public long pushEnergy(class_1937 level, class_2338 pos, class_2350 side, long howMuch) {
        try (Transaction tx = Transaction.openOuter();){
            long inserted = Objects.requireNonNullElse((EnergyStorage)EnergyStorage.SIDED.find(level, pos, (Object)side), EnergyStorage.EMPTY).insert(howMuch, (TransactionContext)tx);
            tx.commit();
            long l = inserted;
            return l;
        }
    }

    @Override
    public CableTile createCable(class_2338 pos, class_2680 state, Tier variant) {
        return new FabricCableTile(pos, state, variant);
    }

    @Override
    public long chargeItemsInPlayerInv(class_1657 player, long maxPerSlot, long maxTotal, Predicate<class_1799> allowStack) {
        TrinketComponent trinketComponent;
        ArrayList list = new ArrayList(PlayerInventoryStorage.of((class_1657)player).getSlots());
        if (FabricLoader.getInstance().isModLoaded("trinkets") && (trinketComponent = (TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).orElse(null)) != null) {
            trinketComponent.getInventory().forEach(($, map) -> map.forEach(($$, container) -> list.addAll(InventoryStorage.of((class_1263)container, null).getSlots())));
        }
        return this.transferSlotList(EnergyStorage::insert, list, maxPerSlot, maxTotal, allowStack);
    }

    @Override
    public long chargeItemsInContainer(class_1263 container, long maxPerSlot, long maxTotal) {
        return this.chargeItemsInContainer(container, maxPerSlot, maxTotal, s -> true);
    }

    public long chargeItemsInContainer(class_1263 container, long maxPerSlot, long maxTotal, Predicate<class_1799> allowStack) {
        return this.transferSlotList(EnergyStorage::insert, InventoryStorage.of((class_1263)container, null).getSlots(), maxPerSlot, maxTotal, allowStack);
    }

    @Override
    public long chargeItemsInInventory(Inventory inv, int slotFrom, int slotTo, long maxPerSlot, long maxTotal) {
        return this.transferSlotList(EnergyStorage::insert, this.createInvWrapper((Inventory)inv).parts.subList(slotFrom, slotTo), maxPerSlot, maxTotal, s -> true);
    }

    @Override
    public long dischargeItemsInInventory(Inventory inv, long maxPerSlot, long maxTotal) {
        return this.transferSlotList(EnergyStorage::extract, this.createInvWrapper((Inventory)inv).parts, maxPerSlot, maxTotal, s -> true);
    }

    private long transferSlotList(EnergyTransferOperation op, Iterable<? extends SingleSlotStorage<ItemVariant>> slots, long maxPerSlot, long maxTotal, Predicate<class_1799> allowStack) {
        long charged = 0L;
        try (Transaction transaction = Transaction.openOuter();){
            for (SingleSlotStorage<ItemVariant> singleSlotStorage : slots) {
                EnergyStorage storage;
                if (!allowStack.test(((ItemVariant)singleSlotStorage.getResource()).toStack()) || (storage = (EnergyStorage)ContainerItemContext.ofSingleSlot(singleSlotStorage).find(EnergyStorage.ITEM)) == null) continue;
                charged += op.perform(storage, Math.min(maxPerSlot, maxTotal - charged), (TransactionContext)transaction);
            }
            transaction.commit();
        }
        return charged;
    }

    private static interface EnergyTransferOperation {
        public long perform(EnergyStorage var1, long var2, TransactionContext var4);
    }
}

